/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth;

import be.kdg.labyrinth.Player;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class Board {
    private char[][] maze;
    private int rows;
    private int cols;

    public Board(String csvFilePath) {
        this.loadLabyrinthFromCSV(csvFilePath);
    }

    private void loadLabyrinthFromCSV(String filePath) {
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            int rowCount = 0;
            while (br.readLine() != null) {
                ++rowCount;
            }
            System.out.println("Aantal rijen in het bestand: " + rowCount);
            br.close();
            BufferedReader br2 = new BufferedReader(new FileReader(filePath));
            String line = br2.readLine();
            int colCount = line.split(",\\s*").length;
            this.rows = rowCount;
            this.cols = colCount;
            this.maze = new char[this.rows][this.cols];
            String[] columns = line.split(",\\s*");
            for (int col = 0; col < columns.length; ++col) {
                this.maze[0][col] = columns[col].charAt(0);
            }
            int row = 1;
            while ((line = br2.readLine()) != null) {
                columns = line.split(",\\s*");
                for (int col = 0; col < columns.length; ++col) {
                    this.maze[row][col] = columns[col].charAt(0);
                }
                ++row;
            }
            br2.close();
        }
        catch (IOException e) {
            System.out.println("Fout bij het laden van het CSV-bestand: " + e.getMessage());
        }
    }

    public void printLabyrinth(int playerRow, int playerCol) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (r == playerRow && c == playerCol) {
                    System.out.print("P ");
                    continue;
                }
                System.out.print(this.maze[r][c] + " ");
            }
            System.out.println();
        }
    }

    public boolean isWall(int r, int c) {
        return this.maze[r][c] == '#';
    }

    public boolean isExit(int r, int c) {
        return this.maze[r][c] == 'E';
    }

    public boolean isTeleport(int r, int c) {
        return this.maze[r][c] == 'O';
    }

    public void teleport(Player player) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.maze[r][c] != 'O' || r == player.getRow() && c == player.getCol()) continue;
                player.setPosition(r, c);
                System.out.println("Je wordt geteleporteerd naar: (" + r + "," + c + ")");
                return;
            }
        }
    }

    public int getStartRow() {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.maze[r][c] != 'S') continue;
                System.out.println("Startpositie gevonden op rij: " + r + ", kolom: " + c);
                return r;
            }
        }
        return 0;
    }

    public int getStartCol() {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.maze[r][c] != 'S') continue;
                System.out.println("Startpositie gevonden op rij: " + r + ", kolom: " + c);
                return c;
            }
        }
        return 0;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }
}

