/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth;

import be.kdg.labyrinth.Board;
import be.kdg.labyrinth.Highscore;
import be.kdg.labyrinth.Player;
import java.util.Scanner;

public class Game {
    private Board board = new Board("src/be/kdg/labyrinth/Labyrinth.csv");
    private Player player = new Player(this.board.getStartRow(), this.board.getStartCol());
    private final Highscore highscore = new Highscore();
    private static final String CSV_PATH = "src/be/kdg/labyrinth/Labyrinth.csv";

    public void start() {
        Scanner scanner = new Scanner(System.in);
        boolean opnieuwSpelen = true;
        while (opnieuwSpelen) {
            System.out.println("Welkom bij het Labyrinth");
            this.highscore.displayHighscores();
            this.board.printLabyrinth(this.player.getRow(), this.player.getCol());
            long starttime = System.currentTimeMillis();
            do {
                String input;
                System.out.println("Gebruik z (omhoog), s (omlaag), q (links), d (rechts): ");
                switch (input = scanner.nextLine()) {
                    case "z": {
                        this.player.move(-1, 0, this.board);
                        break;
                    }
                    case "s": {
                        this.player.move(1, 0, this.board);
                        break;
                    }
                    case "q": {
                        this.player.move(0, -1, this.board);
                        break;
                    }
                    case "d": {
                        this.player.move(0, 1, this.board);
                        break;
                    }
                    default: {
                        System.out.println("Foute invoer, gebruik: z, s, q, d");
                    }
                }
                this.board.printLabyrinth(this.player.getRow(), this.player.getCol());
            } while (!this.board.isExit(this.player.getRow(), this.player.getCol()));
            System.out.println("Je hebt gewonnen!");
            long endtime = System.currentTimeMillis();
            long totalTime = (endtime - starttime) / 1000L;
            System.out.println("Je hebt het labyrinth voltooid in: " + totalTime + " seconden");
            this.highscore.addScore(totalTime);
            this.highscore.displayHighscores();
            System.out.println("Wil je opnieuw spelen? (ja/nee)");
            String antwoord = scanner.nextLine().toLowerCase();
            if (antwoord.equals("nee")) {
                System.out.println("Bedankt voor het spelen!");
                opnieuwSpelen = false;
                continue;
            }
            this.board = new Board(CSV_PATH);
            this.player = new Player(this.board.getStartRow(), this.board.getStartCol());
        }
    }
}

