/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.model;

import be.kdg.labyrinth.JavaFX.model.LabyrinthModel;
import be.kdg.labyrinth.JavaFX.model.PlayerModel;
import be.kdg.labyrinth.JavaFX.model.ScoreModel;
import java.util.List;

public class GameModel {
    private final LabyrinthModel labyrinthModel;
    private final PlayerModel playerModel;
    private ScoreModel scoreModel;
    private final String difficulty;

    public GameModel(String csvFile, String difficulty) {
        this.labyrinthModel = new LabyrinthModel(csvFile);
        int startRow = this.labyrinthModel.findStartRow();
        int startCol = this.labyrinthModel.findStartCol(startRow);
        this.playerModel = new PlayerModel(startRow, startCol, this.labyrinthModel);
        this.scoreModel = new ScoreModel();
        this.difficulty = difficulty;
    }

    public char[][] getLabyrinth() {
        return this.labyrinthModel.getLabyrinth();
    }

    public int getPlayerRow() {
        return this.playerModel.getPlayerRow();
    }

    public int getPlayerCol() {
        return this.playerModel.getPlayerCol();
    }

    public List<int[]> getTrail() {
        return this.playerModel.getTrail();
    }

    public void movePlayer(int deltaRow, int deltaCol) {
        this.playerModel.movePlayer(deltaRow, deltaCol, this.labyrinthModel.getLabyrinth());
    }

    public void reset() {
        int startRow = this.labyrinthModel.findStartRow();
        int startCol = this.labyrinthModel.findStartCol(startRow);
        this.playerModel.reset(startRow, startCol);
        this.scoreModel = new ScoreModel();
    }

    public void saveHighscore(long elapsedTime, String playerName) {
        this.scoreModel.saveHighscore(elapsedTime, playerName, this.difficulty);
    }
}

