/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.model;

import be.kdg.labyrinth.JavaFX.model.LabyrinthModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PlayerModel {
    private int playerRow;
    private int playerCol;
    private final List<int[]> trail;
    private final LabyrinthModel labyrinthModel;

    public PlayerModel(int startRow, int startCol, LabyrinthModel labyrinthModel) {
        this.playerRow = startRow;
        this.playerCol = startCol;
        this.trail = new ArrayList<int[]>();
        this.trail.add(new int[]{this.playerRow, this.playerCol});
        this.labyrinthModel = labyrinthModel;
    }

    public int getPlayerRow() {
        return this.playerRow;
    }

    public int getPlayerCol() {
        return this.playerCol;
    }

    public List<int[]> getTrail() {
        return this.trail;
    }

    public void movePlayer(int deltaRow, int deltaCol, char[][] labyrinth) {
        int newRow = this.playerRow + deltaRow;
        int newCol = this.playerCol + deltaCol;
        if (newRow >= 0 && newRow < labyrinth.length && newCol >= 0 && newCol < labyrinth[0].length) {
            if (labyrinth[newRow][newCol] == '#') {
                this.reset(this.labyrinthModel.findStartRow(), this.labyrinthModel.findStartCol(this.labyrinthModel.findStartRow()));
            } else if (labyrinth[newRow][newCol] == '.' || labyrinth[newRow][newCol] == 'E' || labyrinth[newRow][newCol] == 'O') {
                this.playerRow = newRow;
                this.playerCol = newCol;
                this.trail.add(new int[]{this.playerRow, this.playerCol});
                if (labyrinth[this.playerRow][this.playerCol] == 'O') {
                    this.teleportPlayer(labyrinth);
                }
            }
        } else {
            this.reset(this.labyrinthModel.findStartRow(), this.labyrinthModel.findStartCol(this.labyrinthModel.findStartRow()));
        }
    }

    private void teleportPlayer(char[][] labyrinth) {
        int newCol;
        int newRow;
        Random rand = new Random();
        int maxAttempts = 100;
        int attempts = 0;
        while (labyrinth[newRow = rand.nextInt(labyrinth.length)][newCol = rand.nextInt(labyrinth[0].length)] != '.' && ++attempts < maxAttempts) {
        }
        if (attempts >= maxAttempts) {
            newRow = this.labyrinthModel.findStartRow();
            newCol = this.labyrinthModel.findStartCol(newRow);
        }
        this.playerRow = newRow;
        this.playerCol = newCol;
        this.trail.add(new int[]{this.playerRow, this.playerCol});
    }

    public void reset(int startRow, int startCol) {
        this.playerRow = startRow;
        this.playerCol = startCol;
        this.trail.clear();
        this.trail.add(new int[]{this.playerRow, this.playerCol});
    }
}

