/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import be.kdg.labyrinth.JavaFX.view.AboutPresenter;
import be.kdg.labyrinth.JavaFX.view.AboutView;
import be.kdg.labyrinth.JavaFX.view.DifficultyPresenter;
import be.kdg.labyrinth.JavaFX.view.DifficultyView;
import be.kdg.labyrinth.JavaFX.view.HighscoresPresenter;
import be.kdg.labyrinth.JavaFX.view.HighscoresView;
import be.kdg.labyrinth.JavaFX.view.StartView;
import be.kdg.labyrinth.JavaFX.view.TutorialPresenter;
import be.kdg.labyrinth.JavaFX.view.TutorialView;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class StartPresenter {
    private final GameModel model;
    private final StartView view;
    private final Stage stage;

    public StartPresenter(GameModel model, StartView view, Stage stage) {
        this.model = model;
        this.view = view;
        this.stage = stage;
        this.addEventHandlers();
    }

    private void addEventHandlers() {
        this.view.getPlayButton().setOnAction(e -> this.showDifficulty());
        this.view.getAboutButton().setOnAction(e -> this.showAbout());
        this.view.getTutorialButton().setOnAction(e -> this.showTutorial());
        this.view.getHighscoresButton().setOnAction(e -> this.showHighscores());
        this.view.getExitButton().setOnAction(e -> this.stage.close());
    }

    private void showDifficulty() {
        DifficultyView difficultyView = new DifficultyView();
        new DifficultyPresenter(difficultyView, this.stage, this.model);
        Scene scene = new Scene(difficultyView, 1500.0, 800.0);
        this.stage.setScene(scene);
        this.stage.setFullScreen(false);
        this.stage.setResizable(true);
    }

    private void showAbout() {
        AboutView aboutView = new AboutView(true);
        new AboutPresenter(aboutView, this.stage);
        Scene scene = new Scene(aboutView, 1500.0, 800.0);
        this.stage.setScene(scene);
        this.stage.setFullScreen(false);
        this.stage.setResizable(true);
    }

    private void showTutorial() {
        TutorialView tutorialView = new TutorialView(true);
        new TutorialPresenter(tutorialView, this.stage);
        Scene scene = new Scene(tutorialView, 1500.0, 800.0);
        this.stage.setScene(scene);
        this.stage.setFullScreen(false);
        this.stage.setResizable(true);
    }

    private void showHighscores() {
        HighscoresView highscoresView = new HighscoresView();
        new HighscoresPresenter(highscoresView, this.stage);
        Scene scene = new Scene(highscoresView, 1500.0, 800.0);
        this.stage.setScene(scene);
        this.stage.setFullScreen(false);
        this.stage.setResizable(true);
    }
}

