/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class StartView
extends StackPane {
    private Button playButton;
    private Button highscoresButton;
    private Button aboutButton;
    private Button tutorialButton;
    private Button exitButton;
    private Label titleLabel;

    public StartView() {
        this.initializeNodes();
        this.layoutNodes();
        this.setPrefSize(1500.0, 800.0);
    }

    private void initializeNodes() {
        this.titleLabel = new Label("Labyrinth");
        this.titleLabel.setStyle("-fx-font-size: 80px; -fx-font-family: 'Berlin Sans FB'; -fx-font-weight: bold;-fx-padding: 0px 0px 30px 0px; -fx-text-fill: white;");
        this.playButton = this.createStyledButton("Play");
        this.highscoresButton = this.createStyledButton("Highscores");
        this.aboutButton = this.createStyledButton("About");
        this.tutorialButton = this.createStyledButton("Tutorial");
        this.exitButton = this.createStyledButton("Exit");
    }

    private Button createStyledButton(String text) {
        Button button = new Button(text);
        button.setStyle("-fx-font-size: 40px; -fx-font-family: 'Berlin Sans FB'; -fx-padding: 15px; -fx-min-width: 250px; -fx-min-height: 70px; -fx-border-color: white; -fx-border-radius: 10px; -fx-border-width: 3px; -fx-text-fill: white; -fx-background-color: transparent; -fx-background-insets: 0; -fx-background-radius: 10px;");
        return button;
    }

    private void layoutNodes() {
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/Land.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(1920.0);
        backgroundView.setFitHeight(1080.0);
        Region overlay = new Region();
        overlay.setPrefSize(800.0, 600.0);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");
        VBox vbox = new VBox(30.0);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll((Node[])new Node[]{this.titleLabel, this.playButton, this.highscoresButton, this.aboutButton, this.tutorialButton, this.exitButton});
        this.getChildren().addAll((Node[])new Node[]{backgroundView, overlay, vbox});
        this.setAlignment(Pos.CENTER);
    }

    public Button getPlayButton() {
        return this.playButton;
    }

    public Button getHighscoresButton() {
        return this.highscoresButton;
    }

    public Button getAboutButton() {
        return this.aboutButton;
    }

    public Button getTutorialButton() {
        return this.tutorialButton;
    }

    public Button getExitButton() {
        return this.exitButton;
    }
}

