/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.model;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class LabyrinthModel {
    private final char[][] labyrinth;

    public LabyrinthModel(String csvFile) {
        this.labyrinth = this.loadLabyrinthFromCSV(csvFile);
    }

    private char[][] loadLabyrinthFromCSV(String csvFile) {
        char[][] labyrinth = null;
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                lines.add(line.replace(",", "").replace(" ", ""));
            }
            labyrinth = new char[lines.size()][];
            for (int i = 0; i < lines.size(); ++i) {
                labyrinth[i] = ((String)lines.get(i)).toCharArray();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return labyrinth;
    }

    public char[][] getLabyrinth() {
        return this.labyrinth;
    }

    public int findStartRow() {
        for (int row = 0; row < this.labyrinth.length; ++row) {
            for (int col = 0; col < this.labyrinth[row].length; ++col) {
                if (this.labyrinth[row][col] != 'S') continue;
                return row;
            }
        }
        return -1;
    }

    public int findStartCol(int startRow) {
        if (startRow == -1) {
            return -1;
        }
        for (int col = 0; col < this.labyrinth[startRow].length; ++col) {
            if (this.labyrinth[startRow][col] != 'S') continue;
            return col;
        }
        return -1;
    }
}

