/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScoreModel {
    private final int score;

    public ScoreModel() {
        this.score = 0;
    }

    public int getScore() {
        return this.score;
    }

    public void saveHighscore(long elapsedTime, String playerName, String difficulty) {
        String fileName = "src/be/kdg/labyrinth/Highscores" + difficulty + ".txt";
        try {
            List highscores = new ArrayList<Object>();
            File file = new File(fileName);
            if (file.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        highscores.add(line);
                    }
                }
            }
            String newHighscore = this.formatTime(elapsedTime) + " - " + playerName;
            highscores.add(newHighscore);
            highscores.sort((t1, t2) -> {
                try {
                    String[] parts1 = t1.split(" - ")[0].split(":");
                    String[] parts2 = t2.split(" - ")[0].split(":");
                    if (parts1.length != 3 || parts2.length != 3) {
                        return 0;
                    }
                    int time1 = Integer.parseInt(parts1[0]) * 3600 + Integer.parseInt(parts1[1]) * 60 + Integer.parseInt(parts1[2]);
                    int time2 = Integer.parseInt(parts2[0]) * 3600 + Integer.parseInt(parts2[1]) * 60 + Integer.parseInt(parts2[2]);
                    return Integer.compare(time1, time2);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            });
            if (highscores.size() > 5) {
                highscores = highscores.subList(0, 5);
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (String score : highscores) {
                    writer.write(score + "\n");
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error saving highscore: " + e.getMessage());
        }
    }

    private String formatTime(long millis) {
        int seconds = (int)(millis / 1000L) % 60;
        int minutes = (int)(millis / 60000L % 60L);
        int hours = (int)(millis / 3600000L % 24L);
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}

