/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import be.kdg.labyrinth.JavaFX.view.DifficultyView;
import be.kdg.labyrinth.JavaFX.view.GamePresenter;
import be.kdg.labyrinth.JavaFX.view.GameView;
import be.kdg.labyrinth.JavaFX.view.StartPresenter;
import be.kdg.labyrinth.JavaFX.view.StartView;
import java.util.Optional;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class DifficultyPresenter {
    private final DifficultyView view;
    private final Stage stage;
    private GameModel model;

    public DifficultyPresenter(DifficultyView view, Stage stage, GameModel model) {
        this.view = view;
        this.stage = stage;
        this.model = model;
        this.addEventHandlers();
    }

    private void addEventHandlers() {
        this.view.getEasyButton().setOnAction(e -> this.startGame("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"));
        this.view.getMediumButton().setOnAction(e -> this.startGame("src/be/kdg/labyrinth/LabyrinthMedium.csv", "Medium"));
        this.view.getHardButton().setOnAction(e -> this.startGame("src/be/kdg/labyrinth/LabyrinthHard.csv", "Hard"));
        this.view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, this.stage);
            Scene scene = new Scene(startView, 1500.0, 800.0);
            this.stage.setScene(scene);
            this.stage.setFullScreen(false);
            this.stage.setResizable(true);
        });
    }

    private void startGame(String csvFile, String difficulty) {
        this.model = new GameModel(csvFile, difficulty);
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("Spelernaam");
        dialog.setHeaderText("Voer uw naam in");
        dialog.setContentText("Naam:");
        Optional result = dialog.showAndWait();
        if (result.isEmpty()) {
            return;
        }
        String playerName = (String)result.get();
        if (playerName.trim().isEmpty()) {
            playerName = "Anoniem";
        }
        int rows = this.model.getLabyrinth().length;
        int cols = this.model.getLabyrinth()[0].length;
        GameView gameView = new GameView(this.stage.getWidth(), this.stage.getHeight(), rows, cols, playerName, difficulty);
        new GamePresenter(this.model, gameView, this.stage);
        Scene scene = new Scene(gameView, 1500.0, 800.0);
        this.stage.setScene(scene);
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        this.stage.setWidth(screenBounds.getWidth() * 0.8);
        this.stage.setHeight(screenBounds.getHeight() * 0.8);
        this.stage.centerOnScreen();
        this.stage.show();
    }
}

