/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class DifficultyView
extends StackPane {
    private Button easyButton;
    private Button mediumButton;
    private Button hardButton;
    private Button backButton;
    private Label titleLabel;

    public DifficultyView() {
        this.initializeNodes();
        this.layoutNodes();
        this.setPrefSize(1000.0, 800.0);
    }

    private void initializeNodes() {
        this.titleLabel = new Label("Kies een moeilijkheidsgraad");
        this.titleLabel.setStyle("-fx-font-size: 50px; -fx-font-family: 'Berlin Sans FB'; -fx-font-weight: bold; -fx-text-fill: white;");
        this.easyButton = this.createStyledButton("Easy");
        this.mediumButton = this.createStyledButton("Medium");
        this.hardButton = this.createStyledButton("Hard");
        this.backButton = this.createStyledButton("Back");
    }

    private Button createStyledButton(String text) {
        Button button = new Button(text);
        button.setStyle("-fx-font-size: 40px; -fx-font-family: 'Berlin Sans FB'; -fx-padding: 15px; -fx-min-width: 250px; -fx-min-height: 70px; -fx-border-color: white; -fx-border-radius: 10px; -fx-border-width: 3px; -fx-text-fill: white; -fx-background-color: transparent; -fx-background-insets: 0; -fx-background-radius: 10px;");
        return button;
    }

    private void layoutNodes() {
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/Land.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(1920.0);
        backgroundView.setFitHeight(1080.0);
        Region overlay = new Region();
        overlay.setPrefSize(800.0, 600.0);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");
        VBox vbox = new VBox(30.0);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll((Node[])new Node[]{this.titleLabel, this.easyButton, this.mediumButton, this.hardButton, this.backButton});
        this.getChildren().addAll((Node[])new Node[]{backgroundView, overlay, vbox});
        this.setAlignment(Pos.CENTER);
    }

    public Button getEasyButton() {
        return this.easyButton;
    }

    public Button getMediumButton() {
        return this.mediumButton;
    }

    public Button getHardButton() {
        return this.hardButton;
    }

    public Button getBackButton() {
        return this.backButton;
    }
}

