/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import be.kdg.labyrinth.JavaFX.view.AboutPresenter;
import be.kdg.labyrinth.JavaFX.view.AboutView;
import be.kdg.labyrinth.JavaFX.view.GameView;
import be.kdg.labyrinth.JavaFX.view.StartPresenter;
import be.kdg.labyrinth.JavaFX.view.StartView;
import be.kdg.labyrinth.JavaFX.view.TutorialPresenter;
import be.kdg.labyrinth.JavaFX.view.TutorialView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Duration;

public class GamePresenter {
    private final GameModel model;
    private final GameView view;
    private Timeline timer;
    private long startTime;
    private final Stage stage;
    private List<Long> highscores;

    public GamePresenter(GameModel model, GameView view, Stage stage) {
        this.model = model;
        this.view = view;
        this.stage = stage;
        this.highscores = new ArrayList<Long>();
        this.startGameLoop();
        this.addEventHandlers();
        Platform.runLater(() -> {
            view.setFocusTraversable(true);
            view.requestFocus();
        });
        stage.getScene().setOnMouseClicked(event -> view.requestFocus());
    }

    private void startGameLoop() {
        this.startTime = System.currentTimeMillis();
        this.timer = new Timeline(new KeyFrame(Duration.seconds(0.1), e -> this.updateView(), new KeyValue[0]));
        this.timer.setCycleCount(-1);
        this.timer.play();
    }

    private void updateView() {
        char[][] labyrinth = this.model.getLabyrinth();
        int playerRow = this.model.getPlayerRow();
        int playerCol = this.model.getPlayerCol();
        for (int row = 0; row < labyrinth.length; ++row) {
            for (int col = 0; col < labyrinth[row].length; ++col) {
                this.view.drawTile(row, col, labyrinth[row][col]);
            }
        }
        for (int[] pos : this.model.getTrail()) {
            if (labyrinth[pos[0]][pos[1]] == 'O') continue;
            this.view.drawTrail(pos[0], pos[1]);
        }
        this.view.drawPlayer(playerRow, playerCol);
        this.view.updateTime(this.getElapsedTime());
        this.view.updatePlayerPosition(playerRow, playerCol);
        if (labyrinth[playerRow][playerCol] == 'E') {
            this.timer.stop();
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            this.model.saveHighscore(elapsedTime, this.view.getPlayerName());
            Platform.runLater(this::showEndGameAlert);
        }
    }

    private void addEventHandlers() {
        this.view.setOnKeyPressed(event -> {
            KeyCode keyCode = event.getCode();
            this.view.updateKeypressedLabel(keyCode.toString());
            if (keyCode == KeyCode.Z || keyCode == KeyCode.UP) {
                this.model.movePlayer(-1, 0);
            } else if (keyCode == KeyCode.S || keyCode == KeyCode.DOWN) {
                this.model.movePlayer(1, 0);
            } else if (keyCode == KeyCode.Q || keyCode == KeyCode.LEFT) {
                this.model.movePlayer(0, -1);
            } else if (keyCode == KeyCode.D || keyCode == KeyCode.RIGHT) {
                this.model.movePlayer(0, 1);
            }
            this.view.requestFocus();
        });
        this.view.getBackButton().setOnAction(e -> {
            this.timer.stop();
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, this.stage);
            Scene scene = new Scene(startView, 1500.0, 800.0);
            this.stage.setScene(scene);
            this.stage.setFullScreen(false);
            this.stage.setResizable(true);
        });
        this.view.getAboutMenuItem().setOnAction(e -> {
            AboutView aboutView = new AboutView(false);
            new AboutPresenter(aboutView, new Stage());
            Stage aboutStage = new Stage();
            aboutStage.setTitle("Over deze game");
            Scene scene = new Scene(aboutView, 800.0, 600.0);
            aboutStage.setScene(scene);
            aboutStage.setResizable(false);
            aboutStage.show();
        });
        this.view.getTutorialMenuItem().setOnAction(e -> {
            TutorialView tutorialView = new TutorialView(false);
            new TutorialPresenter(tutorialView, new Stage());
            Stage tutorialStage = new Stage();
            tutorialStage.setTitle("Tutorial");
            Scene scene = new Scene(tutorialView, 800.0, 600.0);
            tutorialStage.setScene(scene);
            tutorialStage.setResizable(false);
            tutorialStage.show();
        });
    }

    private String getElapsedTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        return this.formatTime(elapsedTime);
    }

    private String formatTime(long millis) {
        int seconds = (int)(millis / 1000L) % 60;
        int minutes = (int)(millis / 60000L % 60L);
        int hours = (int)(millis / 3600000L % 24L);
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void showEndGameAlert() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Gewonnen!");
        alert.setHeaderText("Je hebt het einde bereikt!");
        alert.setContentText("Wil je opnieuw spelen?");
        ButtonType buttonTypeYes = new ButtonType("Ja");
        ButtonType buttonTypeNo = new ButtonType("Nee");
        alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{buttonTypeYes, buttonTypeNo});
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == buttonTypeYes) {
            this.model.reset();
            this.startGameLoop();
        } else {
            this.timer.stop();
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, this.stage);
            Scene scene = new Scene(startView, 1500.0, 800.0);
            this.stage.setScene(scene);
            this.stage.setFullScreen(false);
            this.stage.setResizable(true);
        }
    }
}

