/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class GameView
extends BorderPane {
    private final Canvas canvas;
    private final GraphicsContext gc;
    private Label titleLabel;
    private Label timeLabel;
    private Label playerPositionLabel;
    private Label scoresLabel;
    private Label keyPressedLabel;
    private Button backButton;
    private MenuBar menuBar;
    private MenuItem aboutMenuItem;
    private MenuItem tutorialMenuItem;
    private int tileSize;
    private final int rows;
    private final int cols;
    private final String playerName;
    private final String difficulty;
    private final Image bushImage;
    private final Image pathImage;
    private final Image startImage;
    private final Image caveImage;
    private final Image flagImage;
    private final Image playerImage;

    public GameView(double width, double height, int rows, int cols, String playerName, String difficulty) {
        this.rows = rows;
        this.cols = cols;
        this.setPrefSize(width, height);
        this.tileSize = this.calculateTileSize(width * 0.8, height * 0.8, rows, cols);
        this.playerName = playerName;
        this.difficulty = difficulty;
        this.bushImage = new Image("file:src/be/kdg/labyrinth/Bush.jpg");
        this.pathImage = new Image("file:src/be/kdg/labyrinth/Path.jpg");
        this.startImage = new Image("file:src/be/kdg/labyrinth/Start.png");
        this.caveImage = new Image("file:src/be/kdg/labyrinth/Cave.png");
        this.flagImage = new Image("file:src/be/kdg/labyrinth/Flag.jpg");
        this.playerImage = new Image("file:src/be/kdg/labyrinth/Player.png");
        this.canvas = new Canvas(cols * this.tileSize, rows * this.tileSize);
        this.gc = this.canvas.getGraphicsContext2D();
        this.initializeNodes(playerName);
        this.layoutNodes();
        this.widthProperty().addListener((obs, oldVal, newVal) -> this.resizeCanvas());
        this.heightProperty().addListener((obs, oldVal, newVal) -> this.resizeCanvas());
        this.loadHighscores();
    }

    private void resizeCanvas() {
        double newWidth = this.getWidth();
        double newHeight = this.getHeight();
        this.tileSize = this.calculateTileSize(newWidth * 0.8, newHeight * 0.8, this.rows, this.cols);
        this.canvas.setWidth(this.cols * this.tileSize);
        this.canvas.setHeight(this.rows * this.tileSize);
    }

    private int calculateTileSize(double width, double height, int rows, int cols) {
        int tileWidth = (int)(width / (double)cols);
        int tileHeight = (int)(height / (double)rows);
        return Math.min(tileWidth, tileHeight) - 5;
    }

    private void initializeNodes(String playerName) {
        this.titleLabel = new Label("Welkom bij het labyrinth " + playerName);
        this.titleLabel.setStyle("-fx-font-size: 50px; -fx-font-family: 'Berlin Sans FB'; -fx-font-weight: bold; -fx-text-fill: white; -fx-background-color: rgba(0, 0, 0, 0.5); -fx-background-radius: 5px;");
        this.timeLabel = new Label("Tijd: 00:00:00");
        this.timeLabel.setStyle("-fx-font-size: 35px; -fx-text-fill: white; -fx-background-color: rgba(0, 0, 0, 0.5); -fx-background-radius: 5px;");
        this.playerPositionLabel = new Label("Spelerpositie: (0, 0)");
        this.playerPositionLabel.setStyle("-fx-font-size: 35px; -fx-text-fill: white; -fx-background-color: rgba(0, 0, 0, 0.5); -fx-background-radius: 5px;");
        this.keyPressedLabel = new Label("Ingedrukt toets: ");
        this.keyPressedLabel.setStyle("-fx-font-size: 35px; -fx-text-fill: white; -fx-background-color: rgba(0, 0, 0, 0.5); -fx-background-radius: 5px;");
        this.scoresLabel = new Label("Highscores:\nGeen highscores beschikbaar");
        this.scoresLabel.setStyle("-fx-font-size: 20px; -fx-text-fill: white; -fx-background-color: rgba(0, 0, 0, 0.5); -fx-background-radius: 5px;");
        this.backButton = new Button("Terug naar Start");
        this.backButton.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-padding: 10px; -fx-min-width: 150px; -fx-min-height: 50px; -fx-border-color: white; -fx-border-radius: 10px; -fx-border-width: 2px; -fx-text-fill: white; -fx-background-color: transparent; -fx-background-insets: 0; -fx-background-radius: 10px;");
        this.menuBar = new MenuBar();
        Menu menu = new Menu("Menu");
        this.aboutMenuItem = new MenuItem("About");
        this.tutorialMenuItem = new MenuItem("Tutorial");
        menu.getItems().add(this.aboutMenuItem);
        menu.getItems().add(this.tutorialMenuItem);
        this.menuBar.getMenus().add(menu);
    }

    private void layoutNodes() {
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/Land.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(this.getWidth());
        backgroundView.setFitHeight(this.getHeight());
        this.widthProperty().addListener((obs, oldVal, newVal) -> backgroundView.setFitWidth(newVal.doubleValue()));
        this.heightProperty().addListener((obs, oldVal, newVal) -> backgroundView.setFitHeight(newVal.doubleValue()));
        Region overlay = new Region();
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");
        StackPane backgroundPane = new StackPane(backgroundView, overlay);
        backgroundPane.setAlignment(Pos.CENTER);
        VBox topBox = new VBox(25.0);
        topBox.setAlignment(Pos.CENTER);
        topBox.getChildren().addAll((Node[])new Node[]{this.menuBar, this.titleLabel, this.playerPositionLabel, this.keyPressedLabel});
        VBox topRightBox = new VBox(10.0);
        topRightBox.setAlignment(Pos.TOP_RIGHT);
        topRightBox.getChildren().addAll((Node[])new Node[]{this.timeLabel});
        VBox leftBox = new VBox(10.0, this.scoresLabel);
        leftBox.setAlignment(Pos.TOP_LEFT);
        StackPane centerPane = new StackPane(this.canvas);
        centerPane.setAlignment(Pos.CENTER);
        VBox bottomBox = new VBox(10.0);
        bottomBox.setAlignment(Pos.CENTER);
        bottomBox.getChildren().add(this.backButton);
        BorderPane mainPane = new BorderPane();
        mainPane.setTop(topBox);
        mainPane.setRight(topRightBox);
        mainPane.setLeft(leftBox);
        mainPane.setCenter(centerPane);
        mainPane.setBottom(bottomBox);
        StackPane rootPane = new StackPane(backgroundPane, mainPane);
        this.setCenter(rootPane);
    }

    private void loadHighscores() {
        ArrayList<String> highscores = new ArrayList<String>();
        String fileName = "src/be/kdg/labyrinth/Highscores" + this.difficulty + ".txt";
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                highscores.add(line);
            }
        }
        catch (IOException e) {
            System.err.println("Error loading highscores for " + this.difficulty + ": " + e.getMessage());
        }
        StringBuilder formattedHighscores = new StringBuilder("Highscores (" + this.difficulty + "):\n");
        if (highscores.isEmpty()) {
            formattedHighscores.append("Geen highscores beschikbaar");
        } else {
            for (String highscore : highscores) {
                formattedHighscores.append(highscore).append("\n");
            }
        }
        this.scoresLabel.setText(formattedHighscores.toString());
    }

    public void drawTile(int row, int col, char tile) {
        Image overlayImage;
        this.gc.drawImage(this.pathImage, col * this.tileSize, row * this.tileSize, this.tileSize, this.tileSize);
        switch (tile) {
            case '#': {
                Image image = this.bushImage;
                break;
            }
            case 'S': {
                Image image = this.startImage;
                break;
            }
            case 'O': {
                Image image = this.caveImage;
                break;
            }
            case 'E': {
                Image image = this.flagImage;
                break;
            }
            default: {
                Image image = overlayImage = null;
            }
        }
        if (overlayImage != null) {
            this.gc.drawImage(overlayImage, col * this.tileSize, row * this.tileSize, this.tileSize, this.tileSize);
        }
    }

    public void drawPlayer(int row, int col) {
        if (this.playerImage != null) {
            this.gc.drawImage(this.playerImage, col * this.tileSize, row * this.tileSize, this.tileSize, this.tileSize);
        } else {
            System.err.println("Spelerafbeelding is niet geladen!");
        }
    }

    public void drawTrail(int row, int col) {
        this.gc.drawImage(this.pathImage, col * this.tileSize, row * this.tileSize, this.tileSize, this.tileSize);
    }

    public void updateTime(String time) {
        this.timeLabel.setText("Tijd: " + time);
    }

    public void updatePlayerPosition(int row, int col) {
        this.playerPositionLabel.setText("Spelerpositie: (" + row + ", " + col + ")");
    }

    public void updateKeypressedLabel(String key) {
        this.keyPressedLabel.setText("Ingedrukte toets: " + key);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Button getBackButton() {
        return this.backButton;
    }

    public MenuItem getAboutMenuItem() {
        return this.aboutMenuItem;
    }

    public MenuItem getTutorialMenuItem() {
        return this.tutorialMenuItem;
    }
}

