/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import be.kdg.labyrinth.JavaFX.view.HighscoresView;
import be.kdg.labyrinth.JavaFX.view.StartPresenter;
import be.kdg.labyrinth.JavaFX.view.StartView;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class HighscoresPresenter {
    private final HighscoresView view;
    private final Stage stage;

    public HighscoresPresenter(HighscoresView view, Stage stage) {
        this.view = view;
        this.stage = stage;
        this.loadHighscores();
        this.addEventHandlers();
    }

    private void loadHighscores() {
        this.loadHighscoresForDifficulty(this.view.getEasyHighscoresLabel(), "Easy");
        this.loadHighscoresForDifficulty(this.view.getMediumHighscoresLabel(), "Medium");
        this.loadHighscoresForDifficulty(this.view.getHardHighscoresLabel(), "Hard");
    }

    private void loadHighscoresForDifficulty(Label highscoresLabel, String difficulty) {
        ArrayList<String> highscores = new ArrayList<String>();
        String fileName = "src/be/kdg/labyrinth/Highscores" + difficulty + ".txt";
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                highscores.add(line);
            }
        }
        catch (IOException e) {
            System.err.println("Error loading highscores for " + difficulty + ": " + e.getMessage());
        }
        StringBuilder formattedHighscores = new StringBuilder(difficulty + " Highscores:\n");
        if (highscores.isEmpty()) {
            formattedHighscores.append("Geen highscores beschikbaar");
        } else {
            for (String highscore : highscores) {
                formattedHighscores.append(highscore).append("\n");
            }
        }
        highscoresLabel.setText(formattedHighscores.toString());
    }

    private void addEventHandlers() {
        this.view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, this.stage);
            Scene scene = new Scene(startView, 1500.0, 800.0);
            this.stage.setScene(scene);
            this.stage.setFullScreen(false);
            this.stage.setResizable(true);
        });
    }
}

