/*
 * Decompiled with CFR 0.152.
 */
package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class HighscoresView
extends StackPane {
    private Button backButton;
    private Label titleLabel;
    private Label easyHighscoresLabel;
    private Label mediumHighscoresLabel;
    private Label hardHighscoresLabel;

    public HighscoresView() {
        this.initializeNodes();
        this.layoutNodes();
        this.setPrefSize(1000.0, 800.0);
    }

    private void initializeNodes() {
        this.backButton = new Button("Back");
        this.titleLabel = new Label("Highscores");
        this.easyHighscoresLabel = new Label("Easy Highscores:\nGeen highscores beschikbaar");
        this.mediumHighscoresLabel = new Label("Medium Highscores:\nGeen highscores beschikbaar");
        this.hardHighscoresLabel = new Label("Hard Highscores:\nGeen highscores beschikbaar");
        this.backButton.setStyle("-fx-font-size: 25px; -fx-font-family: 'Berlin Sans FB'; -fx-padding: 15px; -fx-min-width: 150px; -fx-min-height: 70px; -fx-border-color: white; -fx-border-radius: 10px; -fx-border-width: 3px; -fx-text-fill: white; -fx-background-color: transparent; -fx-background-insets: 0; -fx-background-radius: 10px;");
        this.titleLabel.setStyle("-fx-font-size: 50px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");
        this.easyHighscoresLabel.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white");
        this.mediumHighscoresLabel.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");
        this.hardHighscoresLabel.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");
    }

    private void layoutNodes() {
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/Land.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(1920.0);
        backgroundView.setFitHeight(1080.0);
        Region overlay = new Region();
        overlay.setPrefSize(800.0, 600.0);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");
        HBox highscoresBox = new HBox(50.0);
        highscoresBox.setAlignment(Pos.CENTER);
        highscoresBox.getChildren().addAll((Node[])new Node[]{this.easyHighscoresLabel, this.mediumHighscoresLabel, this.hardHighscoresLabel});
        VBox vbox = new VBox(20.0);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll((Node[])new Node[]{this.titleLabel, highscoresBox, this.backButton});
        this.getChildren().addAll((Node[])new Node[]{backgroundView, overlay, vbox});
        this.setAlignment(Pos.CENTER);
    }

    public Button getBackButton() {
        return this.backButton;
    }

    public Label getEasyHighscoresLabel() {
        return this.easyHighscoresLabel;
    }

    public Label getMediumHighscoresLabel() {
        return this.mediumHighscoresLabel;
    }

    public Label getHardHighscoresLabel() {
        return this.hardHighscoresLabel;
    }
}

