package be.kdg.labyrinth;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class Board {
    private char[][] maze;
    private int rows, cols;

    public Board(String csvFilePath) {
        loadLabyrinthFromCSV(csvFilePath);
    }

    private void loadLabyrinthFromCSV(String filePath) {
        try (BufferedReader br = new BufferedReader(new FileReader(filePath))) {
            // Eerst de regels tellen en kolommen vaststellen
            String line;
            int rowCount = 0;
            while ((line = br.readLine()) != null) {
                rowCount++;
            }

            System.out.println("Aantal rijen in het bestand: " + rowCount);

            // Ga terug naar de eerste regel van het bestand
            br.close();
            BufferedReader br2 = new BufferedReader(new FileReader(filePath));
            line = br2.readLine();  // Eerste lijn inleiden (met de muren)

            // Veronderstel dat de eerste regel het aantal kolommen heeft
            int colCount = line.split(",\\s*").length; // Verwijder spaties na de komma

            rows = rowCount;
            cols = colCount;
            maze = new char[rows][cols];

            // Vul de maze met de eerste regel (bovenste rij met muren)
            String[] columns = line.split(",\\s*");
            for (int col = 0; col < columns.length; col++) {
                maze[0][col] = columns[col].charAt(0);  // De eerste rij wordt nu handmatig ingevuld
            }

            // Lees de rest van de regels in de maze
            int row = 1;  // Start vanaf de tweede rij, omdat de eerste al is ingevuld
            while ((line = br2.readLine()) != null) {
                columns = line.split(",\\s*");
                for (int col = 0; col < columns.length; col++) {
                    maze[row][col] = columns[col].charAt(0);
                }
                row++;
            }

            br2.close();

        } catch (IOException e) {
            System.out.println("Fout bij het laden van het CSV-bestand: " + e.getMessage());
        }
    }


    public void printLabyrinth(int playerRow, int playerCol) {
        for (int r = 0; r < rows; r++) {
            for (int c = 0; c < cols; c++) {
                if (r == playerRow && c == playerCol) {
                    System.out.print("P "); // Toon speler
                } else {
                    System.out.print(maze[r][c] + " "); // Toon labyrint
                }
            }
            System.out.println();
        }
    }

    public boolean isWall(int r, int c) {
        return maze[r][c] == '#';
    }

    public boolean isExit(int r, int c) {
        return maze[r][c] == 'E';
    }

    public boolean isTeleport(int r, int c) {
        return maze[r][c] == 'O';
    }

    public void teleport(Player player) {
        for (int r = 0; r < rows; r++) {
            for (int c = 0; c < cols; c++) {
                if (maze[r][c] == 'O' && !(r == player.getRow() && c == player.getCol())) {
                    player.setPosition(r, c);
                    System.out.println("Je wordt geteleporteerd naar: (" + r + "," + c + ")");
                    return;
                }
            }
        }
    }

    public int getStartRow() {
        for (int r = 0; r < rows; r++) {
            for (int c = 0; c < cols; c++) {
                if (maze[r][c] == 'S') {
                    System.out.println("Startpositie gevonden op rij: " + r + ", kolom: " + c); // Debug
                    return r;
                }
            }
        }
        return 0;
    }

    public int getStartCol() {
        for (int r = 0; r < rows; r++) {
            for (int c = 0; c < cols; c++) {
                if (maze[r][c] == 'S') {
                    System.out.println("Startpositie gevonden op rij: " + r + ", kolom: " + c); // Debug
                    return c;
                }
            }
        }
        return 0;
    }

    public int getRows() {
        return rows;
    }

    public int getCols() {
        return cols;
    }
}
