package be.kdg.labyrinth;

import javafx.scene.Node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Highscore extends Node {
    private List<Long> higscores;

    public Highscore() {
        higscores = new ArrayList<>();
    }

    public void addScore(long score) {
        higscores.add(score);
        Collections.sort(higscores);
    }

    public void displayHighscores() {
        System.out.println("Highscores:");
        System.out.println("===========");
        if(higscores.isEmpty()) {
            System.out.println("Er zijn nog geen highscores");
        }
        else{
            for(int i = 0; i < Math.min(5, higscores.size()); i++) {
                System.out.println((i+1) + ". " + (higscores.get(i)) + " seconden");
            }
        }
        System.out.println("===========");
    }
}
