package be.kdg.labyrinth.JavaFX.model;

import java.util.List;

public class GameModel {
    private LabyrinthModel labyrinthModel;
    private PlayerModel playerModel;
    private ScoreModel scoreModel;
    private String difficulty; // Nieuwe variabele voor moeilijkheidsgraad

    public GameModel(String csvFile, String difficulty) {
        this.labyrinthModel = new LabyrinthModel(csvFile);
        int startRow = labyrinthModel.findStartRow();
        int startCol = labyrinthModel.findStartCol(startRow);
        this.playerModel = new PlayerModel(startRow, startCol, labyrinthModel);
        this.scoreModel = new ScoreModel();
        this.difficulty = difficulty; // Initialiseer de moeilijkheidsgraad
    }

    public char[][] getLabyrinth() {
        return labyrinthModel.getLabyrinth();
    }

    public int getPlayerRow() {
        return playerModel.getPlayerRow();
    }

    public int getPlayerCol() {
        return playerModel.getPlayerCol();
    }

    public List<int[]> getTrail() {
        return playerModel.getTrail();
    }

    public void movePlayer(int deltaRow, int deltaCol) {
        playerModel.movePlayer(deltaRow, deltaCol, labyrinthModel.getLabyrinth());
    }

    public void reset() {
        int startRow = labyrinthModel.findStartRow();
        int startCol = labyrinthModel.findStartCol(startRow);
        playerModel.reset(startRow, startCol);
        scoreModel = new ScoreModel();
    }

    public void saveHighscore(long elapsedTime) {
        scoreModel.saveHighscore(elapsedTime, difficulty); // Sla de moeilijkheidsgraad op
    }

    public int getScore() {
        return scoreModel.getScore();
    }

    public String getDifficulty() {
        return difficulty;
    }
}