package be.kdg.labyrinth.JavaFX.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PlayerModel {
    private int playerRow;
    private int playerCol;
    private List<int[]> trail;
    private LabyrinthModel labyrinthModel;

    public PlayerModel(int startRow, int startCol, LabyrinthModel labyrinthModel) {
        this.playerRow = startRow;
        this.playerCol = startCol;
        this.trail = new ArrayList<>();
        this.trail.add(new int[]{playerRow, playerCol});
        this.labyrinthModel = labyrinthModel;
    }

    public int getPlayerRow() {
        return playerRow;
    }

    public int getPlayerCol() {
        return playerCol;
    }

    public List<int[]> getTrail() {
        return trail;
    }

    public void movePlayer(int deltaRow, int deltaCol, char[][] labyrinth) {
        int newRow = playerRow + deltaRow;
        int newCol = playerCol + deltaCol;

        // Controleer of de nieuwe positie binnen de grenzen van het labyrint ligt
        if (newRow >= 0 && newRow < labyrinth.length && newCol >= 0 && newCol < labyrinth[0].length) {
            // Controleer of de nieuwe positie een muur is
            if (labyrinth[newRow][newCol] == '#') {
                // Teleporteer de speler terug naar het startpunt
                reset(labyrinthModel.findStartRow(), labyrinthModel.findStartCol(labyrinthModel.findStartRow()));
            } else if (labyrinth[newRow][newCol] == '.' || labyrinth[newRow][newCol] == 'E' || labyrinth[newRow][newCol] == 'O') {
                // Beweeg de speler naar de nieuwe positie
                playerRow = newRow;
                playerCol = newCol;
                trail.add(new int[]{playerRow, playerCol});

                // Controleer of de speler op een teleportatiepunt staat
                if (labyrinth[playerRow][playerCol] == 'O') {
                    teleportPlayer(labyrinth);
                }
            }
        } else {
            // Als de nieuwe positie buiten de grenzen van het labyrint ligt, teleporteer de speler terug naar het startpunt
            reset(labyrinthModel.findStartRow(), labyrinthModel.findStartCol(labyrinthModel.findStartRow()));
        }
    }

    private void teleportPlayer(char[][] labyrinth) {
        Random rand = new Random();
        int newRow, newCol;

        do {
            newRow = rand.nextInt(labyrinth.length);
            newCol = rand.nextInt(labyrinth[0].length);
        } while (labyrinth[newRow][newCol] != '.'); // Teleporteer naar een willekeurige vrije cel

        playerRow = newRow;
        playerCol = newCol;
        trail.add(new int[]{playerRow, playerCol});

        System.out.println("Je wordt geteleporteerd naar: (" + playerRow + "," + playerCol + ")");
    }

    public void reset(int startRow, int startCol) {
        this.playerRow = startRow;
        this.playerCol = startCol;
        this.trail.clear();
        this.trail.add(new int[]{playerRow, playerCol});
    }
}