package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class AboutPresenter {
    private AboutView view;
    private Stage stage;

    public AboutPresenter(AboutView view, Stage stage) {
        this.view = view;
        this.stage = stage;
        addEventHandlers();
    }

    private void addEventHandlers() {
        view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, stage);
            Scene scene = new Scene(startView, 1000, 800);
            stage.setScene(scene);
            stage.setFullScreen(false);
            stage.setResizable(true);
        });

    }
}