package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.scene.Scene;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Stage;

public class DifficultyPresenter {
    private DifficultyView view;
    private Stage stage;
    private GameModel model;

    public DifficultyPresenter(DifficultyView view, Stage stage, GameModel model) {
        this.view = view;
        this.stage = stage;
        this.model = model;
        addEventHandlers();
    }

    private void addEventHandlers() {
        view.getEasyButton().setOnAction(e -> startGame("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"));
        view.getMediumButton().setOnAction(e -> startGame("src/be/kdg/labyrinth/LabyrinthMedium.csv", "Medium"));
        view.getHardButton().setOnAction(e -> startGame("src/be/kdg/labyrinth/LabyrinthHard.csv", "Hard"));
        view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, stage);
            Scene scene = new Scene(startView, 1000, 800);
            stage.setScene(scene);
            stage.setFullScreen(false);
            stage.setResizable(true);
        });
    }

    private void startGame(String csvFile, String difficulty) {
        model = new GameModel(csvFile, difficulty); // Geef de moeilijkheidsgraad door
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("Spelernaam");
        dialog.setHeaderText("Voer uw naam in");
        dialog.setContentText("Naam:");

        String playerName = dialog.showAndWait().orElse("Anoniem");

        int rows = model.getLabyrinth().length;
        int cols = model.getLabyrinth()[0].length;

        GameView gameView = new GameView(stage.getWidth(), stage.getHeight(), rows, cols, playerName);
        new GamePresenter(model, gameView, stage);

        Scene scene = new Scene(gameView, 1000, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }
}