package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class DifficultyView extends StackPane {
    private Button easyButton, mediumButton, hardButton, backButton;
    private Label titleLabel;
    private VBox vbox;

    public DifficultyView() {
        initializeNodes();
        layoutNodes();
        this.setPrefSize(1000, 800);
    }

    private void initializeNodes() {
        titleLabel = new Label("Kies een moeilijkheidsgraad");
        titleLabel.setStyle("-fx-font-size: 50px; -fx-font-family: 'Berlin Sans FB'; -fx-font-weight: bold; -fx-text-fill: white;");

        easyButton = createStyledButton("Easy");
        mediumButton = createStyledButton("Medium");
        hardButton = createStyledButton("Hard");
        backButton = createStyledButton("Back");
    }

    private Button createStyledButton(String text) {
        Button button = new Button(text);
        button.setStyle(
                "-fx-font-size: 40px; " +
                        "-fx-font-family: 'Berlin Sans FB'; " +
                        "-fx-padding: 15px; " +
                        "-fx-min-width: 250px; " +
                        "-fx-min-height: 70px; " +
                        "-fx-border-color: white; " +
                        "-fx-border-radius: 10px; " +
                        "-fx-border-width: 3px; " +
                        "-fx-text-fill: white; " +
                        "-fx-background-color: transparent; " +
                        "-fx-background-insets: 0; " +
                        "-fx-background-radius: 10px;");
        return button;
    }



    private void layoutNodes() {
        // Achtergrondafbeelding instellen
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/LabyrinthAchtergrond.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(1920);
        backgroundView.setFitHeight(1080);

        // Semi-transparante overlay
        Region overlay = new Region();
        overlay.setPrefSize(800, 600);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);"); // 50% transparantie

        vbox = new VBox(30);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll(titleLabel, easyButton, mediumButton, hardButton, backButton);

        this.getChildren().addAll(backgroundView, overlay, vbox);
        this.setAlignment(Pos.CENTER);
    }

    public Button getEasyButton() { return easyButton; }
    public Button getMediumButton() { return mediumButton; }
    public Button getHardButton() { return hardButton; }
    public Button getBackButton() {
        return backButton;
    }
}