package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.scene.Scene;
import javafx.stage.Stage;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HighscoresPresenter {
    private HighscoresView view;
    private Stage stage;

    public HighscoresPresenter(HighscoresView view, Stage stage) {
        this.view = view;
        this.stage = stage;
        loadHighscores();
        addEventHandlers();
    }

    private void loadHighscores() {
        List<String> highscores = new ArrayList<>();
        try (BufferedReader reader = new BufferedReader(new FileReader("src/be/kdg/labyrinth/HighscoresEasy.txt"))) {
            String line;
            while ((line = reader.readLine()) != null) {
                highscores.add(line);
            }
        } catch (IOException e) {
            System.err.println("Error loading highscores: " + e.getMessage());
        }

        // Formatteer de highscores voor weergave
        StringBuilder scoresBuilder = new StringBuilder();
        for (int i = 0; i < highscores.size(); i++) {
            scoresBuilder.append(i + 1).append(". ").append(highscores.get(i)).append("\n");
        }
        view.updateHighscores(scoresBuilder.toString());
    }

    private void addEventHandlers() {
        view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, stage);
            Scene scene = new Scene(startView, 1000, 800);
            stage.setScene(scene);
            stage.setFullScreen(false);
            stage.setResizable(true);
        });
    }
}