package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class StartPresenter {
    private GameModel model;
    private StartView view;
    private Stage stage;

    public StartPresenter(GameModel model, StartView view, Stage stage) {
        this.model = model;
        this.view = view;
        this.stage = stage;
        addEventHandlers();
    }

    private void addEventHandlers() {
        view.getPlayButton().setOnAction(e -> showDifficulty());
        view.getAboutButton().setOnAction(e -> showAbout());
        view.getTutorialButton().setOnAction(e -> showTutorial());
        view.getHighscoresButton().setOnAction(e -> showHighscores());
        view.getExitButton().setOnAction(e -> stage.close());
    }

    private void showDifficulty() {
        DifficultyView difficultyView = new DifficultyView();
        new DifficultyPresenter(difficultyView, stage, model);
        Scene scene = new Scene(difficultyView, 1000, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }

    private void showAbout() {
        AboutView aboutView = new AboutView();
        new AboutPresenter(aboutView, stage);
        Scene scene = new Scene(aboutView, 1000, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }

    private void showTutorial() {
        TutorialView tutorialView = new TutorialView();
        new TutorialPresenter(tutorialView, stage);
        Scene scene = new Scene(tutorialView, 1000, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }

    private void showHighscores() {
        HighscoresView highscoresView = new HighscoresView();
        new HighscoresPresenter(highscoresView, stage);
        Scene scene = new Scene(highscoresView, 1000, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }
}