package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;

public class StartView extends StackPane {
    private Button playButton, highscoresButton, aboutButton, tutorialButton, exitButton;
    private Label titleLabel;
    private VBox vbox;

    public StartView() {
        initializeNodes();
        layoutNodes();
        this.setPrefSize(1000, 800);
    }

    private void initializeNodes() {
        titleLabel = new Label("Labyrinth");
        titleLabel.setStyle("-fx-font-size: 80px; -fx-font-family: 'Berlin Sans FB'; -fx-font-weight: bold;-fx-padding: 0px 0px 30px 0px; -fx-text-fill: white;");

        playButton = createStyledButton("Play");
        highscoresButton = createStyledButton("Highscores");
        aboutButton = createStyledButton("About");
        tutorialButton = createStyledButton("Tutorial");
        exitButton = createStyledButton("Exit");
    }

    private Button createStyledButton(String text) {
        Button button = new Button(text);
        button.setStyle(
                "-fx-font-size: 40px; " +
                        "-fx-font-family: 'Berlin Sans FB'; " +
                        "-fx-padding: 15px; " +
                        "-fx-min-width: 250px; " +
                        "-fx-min-height: 70px; " +
                        "-fx-border-color: white; " +
                        "-fx-border-radius: 10px; " +
                        "-fx-border-width: 3px; " +
                        "-fx-text-fill: white; " +
                        "-fx-background-color: transparent; " +
                        "-fx-background-insets: 0; " +
                        "-fx-background-radius: 10px;"
        );
        return button;
    }

    private void layoutNodes() {
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/LabyrinthAchtergrond.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(1920);
        backgroundView.setFitHeight(1080);

        Region overlay = new Region();
        overlay.setPrefSize(800, 600);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");

        vbox = new VBox(30);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll(titleLabel, playButton, highscoresButton, aboutButton, tutorialButton, exitButton);

        this.getChildren().addAll(backgroundView, overlay, vbox);
        this.setAlignment(Pos.CENTER);
    }

    public Button getPlayButton() { return playButton; }
    public Button getHighscoresButton() { return highscoresButton; }
    public Button getAboutButton() { return aboutButton; }
    public Button getTutorialButton() { return tutorialButton; }
    public Button getExitButton() { return exitButton; }
}
