package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class TutorialView extends StackPane {
    private Button backButton;

    public TutorialView() {
        initializeNodes();
        layoutNodes();
        this.setPrefSize(1000, 800);
    }

    private void initializeNodes() {
        backButton = new Button("Back");

        // Styling knoppen
        backButton.setStyle(
                "-fx-font-size: 25px; " +
                        "-fx-font-family: 'Berlin Sans FB'; " +
                        "-fx-padding: 15px; " +
                        "-fx-min-width: 150px; " +
                        "-fx-min-height: 70px; " +
                        "-fx-border-color: white; " +
                        "-fx-border-radius: 10px; " +
                        "-fx-border-width: 3px; " +
                        "-fx-text-fill: white; " +
                        "-fx-background-color: transparent; " +
                        "-fx-background-insets: 0; " +
                        "-fx-background-radius: 10px;");
    }

    private void layoutNodes() {
        // Achtergrondafbeelding instellen
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/LabyrinthAchtergrond.jpg");
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.setFitWidth(1920);
        backgroundView.setFitHeight(1080);

        // Semi-transparante overlay
        Region overlay = new Region();
        overlay.setPrefSize(800, 600);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);"); // 50% transparantie

        VBox vbox = new VBox(20);
        vbox.setAlignment(Pos.CENTER);

        Label tutorialLabel = new Label("Tutorial\n\n1. Gebruik de pijltjestoetsen of ZQSD om te bewegen.\n2. Bereik de uitgang (rood) om te winnen.\n3. Teleportatiepunten (geel) brengen je naar een andere locatie.");
        tutorialLabel.setStyle("-fx-font-size: 30px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");

        vbox.getChildren().addAll(tutorialLabel, backButton);

        this.getChildren().addAll(backgroundView, overlay, vbox);
        this.setAlignment(Pos.CENTER);
    }

    public Button getBackButton() {
        return backButton;
    }
}