package be.kdg.labyrinth;

public class Player {
    private int row, col;

    public Player(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public boolean move(int rowChange, int colChange, Board board) {
        int newRow = row + rowChange;
        int newCol = col + colChange;

        if (newRow >= 0 && newRow < board.getRows() && newCol >= 0 && newCol < board.getCols() && !board.isWall(newRow, newCol)) {
            row = newRow;
            col = newCol;

            if (board.isTeleport(row, col)) {
                board.teleport(this); // Teleporteer de speler
            }

            return true;
        } else {
            System.out.println("Deze move is niet geldig.");
            return false;
        }
    }

    public void setPosition(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public int getRow() {
        return row;
    }

    public int getCol() {
        return col;
    }
}
