package be.kdg.labyrinth.JavaFX.model;

import java.util.List;

public class GameModel {
    private final LabyrinthModel labyrinthModel;
    private final PlayerModel playerModel;
    private ScoreModel scoreModel;
    private final String difficulty;

    public GameModel(String csvFile, String difficulty) {
        this.labyrinthModel = new LabyrinthModel(csvFile); //leest het labyrinth csv bestand
        int startRow = labyrinthModel.findStartRow(); //de startrij zoeken van de speler
        int startCol = labyrinthModel.findStartCol(startRow); //de startkolom zoeken van de speler
        this.playerModel = new PlayerModel(startRow, startCol, labyrinthModel);
        this.scoreModel = new ScoreModel();
        this.difficulty = difficulty;
    }

    public char[][] getLabyrinth() {
        return labyrinthModel.getLabyrinth();
    }

    public int getPlayerRow() {
        return playerModel.getPlayerRow();
    }

    public int getPlayerCol() {
        return playerModel.getPlayerCol();
    }

    public List<int[]> getTrail() {
        return playerModel.getTrail();
    }

    public void movePlayer(int deltaRow, int deltaCol) {
        playerModel.movePlayer(deltaRow, deltaCol, labyrinthModel.getLabyrinth());
    }

    public void reset() {
        int startRow = labyrinthModel.findStartRow();
        int startCol = labyrinthModel.findStartCol(startRow);
        playerModel.reset(startRow, startCol);
        scoreModel = new ScoreModel();
    }

    public void saveHighscore(long elapsedTime, String playerName) {
        scoreModel.saveHighscore(elapsedTime, playerName, difficulty);
    }
}