package be.kdg.labyrinth.JavaFX.model;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LabyrinthModel {
    private final char[][] labyrinth; //we gebruiken een 2 dimensionale array voor de rijen en kolommen

    public LabyrinthModel(String csvFile) {
        this.labyrinth = loadLabyrinthFromCSV(csvFile); //het labyrinth wordt opgeroepen door een CSV bestand
    }

    private char[][] loadLabyrinthFromCSV(String csvFile) {
        char[][] labyrinth = null;
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile))) { //buffereader om tekst te lezen uit een bestand. De filereader opent het bestand
            String line;
            List<String> lines = new ArrayList<>(); //een arraylist om om alle regels van het csv bestand op te slaan

            while ((line = br.readLine()) != null) { //gaat elke lijn van het bestand af tot die het einde bereikt
                if (line.startsWith("\uFEFF")) { //gaat controleren of de regel begint met een BOM (Byte order markt). Speciaal teken dat soms aan het begin van een regel staat
                    line = line.substring(1); //en die verwijderen we met een substring. (dit hebben we gebruikt bij het laatste labyrinth
                }
                lines.add(line.replace(",", "").replace(" ", "")); //hier gaan we alle kommas en spaties weg doen
            }

            labyrinth = new char[lines.size()][]; //hier word 2D array geïnitialiseerd met het aantal rijen gelijk aan de aantal lijnen.
            for (int i = 0; i < lines.size(); i++) {
                labyrinth[i] = lines.get(i).toCharArray(); //zet elke regel om in een array en die wordt dan toegevoed aan de 2D array labyrinth
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return labyrinth;
    }

    public char[][] getLabyrinth() {
        return labyrinth;
    }

    public int findStartRow() {
        for (int row = 0; row < labyrinth.length; row++) {
            for (int col = 0; col < labyrinth[row].length; col++) {
                if (labyrinth[row][col] == 'S') {
                    return row;
                }
            }
        }
        return -1;
    }

    public int findStartCol(int startRow) {
        if (startRow == -1) {
            return -1;
        }

        for (int col = 0; col < labyrinth[startRow].length; col++) {
            if (labyrinth[startRow][col] == 'S') {
                return col;
            }
        }
        return -1;
    }
}