package be.kdg.labyrinth.JavaFX.model;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class ScoreModel {
    private final int score;

    public ScoreModel() {
        this.score = 0;
    }

    public int getScore() {
        return score;
    }

    public void saveHighscore(long elapsedTime, String playerName, String difficulty) {
        String fileName = "src/be/kdg/labyrinth/Highscores" + difficulty + ".txt"; //we hebben 3 verschillende moeilijkhedenbestanden daarom die difficulty ertussen
        try {
            List<String> highscores = new ArrayList<>(); //een arraylist om daar alles in op te slagen van het type string
            File file = new File(fileName);

            if (file.exists()) { //gaat eerst controleren of het bestand bestaat
                try (BufferedReader reader = new BufferedReader(new FileReader(file))) { //buffereader om tekst te lezen uit een bestand. De filereader opent het bestand
                    String line;
                    while ((line = reader.readLine()) != null) { //gaat elke regel lezen en retourneert null als die bij het einde is
                        highscores.add(line); //voegt elke gelezen regel tooe aan de de lijst highsores
                    }
                }
            }

            String newHighscore = formatTime(elapsedTime) + " - " + playerName; //formatteert de tijd door de methode te gebruiken
            highscores.add(newHighscore);

            highscores.sort((t1, t2) -> { //sorteert de lijst van groot naar klein
                try { //de twee tijden vergelijken
                    String[] parts1 = t1.split(" - ")[0].split(":"); //hier gaan we alles opsplitsen, dus de uren minuten en seconden
                    String[] parts2 = t2.split(" - ")[0].split(":"); //we gebruiken [0] omdat we alleen geïnteresseerd zijn in de tijd en niet in de naam

                    if (parts1.length != 3 || parts2.length != 3) { //hier controleren we of de array precies 3 elementen heeft (uren, minuten en seconden)
                        return 0; //als niet retourneert het een 0
                    }

                    int time1 = Integer.parseInt(parts1[0]) * 3600 + Integer.parseInt(parts1[1]) * 60 + Integer.parseInt(parts1[2]); //string converteren nar een integer
                    int time2 = Integer.parseInt(parts2[0]) * 3600 + Integer.parseInt(parts2[1]) * 60 + Integer.parseInt(parts2[2]);
                    return Integer.compare(time1, time2);
                } catch (NumberFormatException e) {
                    return 0;
                }
            });

            if (highscores.size() > 5) { //maximum 5 scores opslaan
                highscores = highscores.subList(0, 5);
            }

            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file))) { //de bufferwriter zorgt ervoor dat die tekst gaat schrijven naar een bestand.
                for (String score : highscores) { //schrijft alles naar de arraylist
                    writer.write(score + "\n");
                }
            }
        } catch (IOException e) {
            System.err.println("Error saving highscore: " + e.getMessage());
        }
    }

    private String formatTime(long millis) { //formaat om de uren minuten en seconden te berekenen, als je alleen de seconden wilt bijvoorbeeld dan doe je alles weg buiten de seconden
        int seconds = (int) (millis / 1000) % 60;
        int minutes = (int) ((millis / (1000 * 60)) % 60);
        int hours = (int) ((millis / (1000 * 60 * 60)) % 24);
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}