package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Screen;
import javafx.stage.Stage;

import java.util.Optional;

public class DifficultyPresenter {
    private final DifficultyView view;
    private final Stage stage;
    private GameModel model;

    public DifficultyPresenter(DifficultyView view, Stage stage, GameModel model) {
        this.view = view;
        this.stage = stage;
        this.model = model;
        addEventHandlers();
    }

    private void addEventHandlers() {
        view.getEasyButton().setOnAction(e -> startGame("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy")); //als je op easy drukt wordt het kleine labyrinth gebruikt. Wordt de Startgame methode gebruikt om het csv bestand te gebruiken.
        view.getMediumButton().setOnAction(e -> startGame("src/be/kdg/labyrinth/LabyrinthMedium.csv", "Medium")); //als je op medium drukt wordt een groter labyrinth getoond
        view.getHardButton().setOnAction(e -> startGame("src/be/kdg/labyrinth/LabyrinthHard.csv", "Hard")); //als je op HARD drukt wordt het grootste labyrinth getoond
        view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, stage);
            Scene scene = new Scene(startView, 1500, 800);
            stage.setScene(scene);
            stage.setFullScreen(false);
            stage.setResizable(true);
        });
    }

    private void startGame(String csvFile, String difficulty) {
        // Maak een nieuw GameModel aan
        model = new GameModel(csvFile, difficulty);

        // Vraag de speler om zijn naam
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("Spelernaam");
        dialog.setHeaderText("Voer uw naam in");
        dialog.setContentText("Naam:");

        Optional<String> result = dialog.showAndWait(); //wacht tot de speler zijn keuze maakt

        if (result.isEmpty()) {
            return; //stop als de speler op cancel drukt
        }

        String playerName = result.get();

        if (playerName.trim().isEmpty()) {
            playerName = "Anoniem"; //als er niets wordt ingevuld is de naam Anoniem
        }

        // Maak een nieuwe GameView aan
        int rows = model.getLabyrinth().length; //aantal rijen
        int cols = model.getLabyrinth()[0].length; //aantal kollommen door alleen de eerste rij op te roepen
        GameView gameView = new GameView(stage.getWidth(), stage.getHeight(), rows, cols, playerName, difficulty); //nieuwe gameview. Het wordt geïnitialiseerd met de breedte en hoogte van het venster. Het aantal rijen en kolommen. spelernaam en moeilijkheidsgraad

        // Maak een nieuwe GamePresenter aan
        new GamePresenter(model, gameView, stage); //verbindt de logica en de UI met elkaar

        // Maak een nieuwe Scene aan
        Scene scene = new Scene(gameView, 1500, 800); //nieuwe scene voor de gameview met een breedte en hoogte

        // Stel de scene in op de stage
        stage.setScene(scene);

        // Haal de schermgrootte op
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();

        // Stel de grootte van het venster in op basis van de schermgrootte
        stage.setWidth(screenBounds.getWidth() * 0.8); // 80% van de schermbreedte
        stage.setHeight(screenBounds.getHeight() * 0.8); // 80% van de schermhoogte

        // Centreer het venster op het scherm
        stage.centerOnScreen();

        // Toon het venster
        stage.show();
    }
}