package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Stage;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HighscoresPresenter {
    private final HighscoresView view;
    private final Stage stage;

    public HighscoresPresenter(HighscoresView view, Stage stage) {
        this.view = view;
        this.stage = stage;
        loadHighscores(); //alle highscores worden opgehaald dit zijn opgeslagen
        addEventHandlers();
    }

    private void loadHighscores() {
        // Laad highscores voor Easy, Medium en Hard
        loadHighscoresForDifficulty(view.getEasyHighscoresLabel(), "Easy");
        loadHighscoresForDifficulty(view.getMediumHighscoresLabel(), "Medium");
        loadHighscoresForDifficulty(view.getHardHighscoresLabel(), "Hard");
    }

    private void loadHighscoresForDifficulty(Label highscoresLabel, String difficulty) {
        List<String> highscores = new ArrayList<>(); //we slagen alles op in een Arraylist als een String
        String fileName = "src/be/kdg/labyrinth/Highscores" + difficulty + ".txt"; //we hebben 3 verschillende moeilijkhedenbestanden daarom die difficulty ertussen

        try (BufferedReader reader = new BufferedReader(new FileReader(fileName))) { //buffereader om tekst te lezen uit een bestand. De filereader opent het bestand
            String line;
            while ((line = reader.readLine()) != null) { //gaat elke regel lezen en retourneert null als die bij het einde is
                highscores.add(line);
            }
        } catch (IOException e) {
            System.err.println("Error loading highscores for " + difficulty + ": " + e.getMessage());
        }

        // Formatteer de highscores voor weergave
        StringBuilder formattedHighscores = new StringBuilder(difficulty + " Highscores:\n"); //we gebruiken een stringbuilder om de strings te manipuleren
        if (highscores.isEmpty()) {
            formattedHighscores.append("Geen highscores beschikbaar"); //als er geen highscores zijn voegt die die erbij toe
        } else {
            for (String highscore : highscores) {
                formattedHighscores.append(highscore).append("\n");
            }
        }

        // Update het label met de highscores
        highscoresLabel.setText(formattedHighscores.toString());
    }

    private void addEventHandlers() {
        view.getBackButton().setOnAction(e -> {
            StartView startView = new StartView();
            new StartPresenter(new GameModel("src/be/kdg/labyrinth/LabyrinthEasy.csv", "Easy"), startView, stage);
            Scene scene = new Scene(startView, 1500, 800);
            stage.setScene(scene);
            stage.setFullScreen(false);
            stage.setResizable(true);
        });
    }
}