package be.kdg.labyrinth.JavaFX.view;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class HighscoresView extends StackPane {
    private Button backButton;
    private Label titleLabel;
    private Label easyHighscoresLabel;
    private Label mediumHighscoresLabel;
    private Label hardHighscoresLabel;

    public HighscoresView() {
        initializeNodes();
        layoutNodes();
        this.setPrefSize(1000, 800);
    }

    private void initializeNodes() {
        backButton = new Button("Back");
        titleLabel = new Label("Highscores");

        easyHighscoresLabel = new Label("Easy Highscores:\nGeen highscores beschikbaar");
        mediumHighscoresLabel = new Label("Medium Highscores:\nGeen highscores beschikbaar");
        hardHighscoresLabel = new Label("Hard Highscores:\nGeen highscores beschikbaar");

        backButton.setStyle( //als je aparte css bestand wilt gebruiken doe je: backbutton.getStyleClass().add("back-button"); die add geef je een naam in zodat je die kan gebruiken in de css file
                "-fx-font-size: 25px; " +
                        "-fx-font-family: 'Berlin Sans FB'; " +
                        "-fx-padding: 15px; " +
                        "-fx-min-width: 150px; " +
                        "-fx-min-height: 70px; " +
                        "-fx-border-color: white; " +
                        "-fx-border-radius: 10px; " +
                        "-fx-border-width: 3px; " +
                        "-fx-text-fill: white; " +
                        "-fx-background-color: transparent; " +
                        "-fx-background-insets: 0; " +
                        "-fx-background-radius: 10px;");

        titleLabel.setStyle("-fx-font-size: 50px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");

        easyHighscoresLabel.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white");
        mediumHighscoresLabel.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");
        hardHighscoresLabel.setStyle("-fx-font-size: 20px; -fx-font-family: 'Berlin Sans FB'; -fx-text-fill: white;");
    }

    private void layoutNodes() {
        Image backgroundImage = new Image("file:src/be/kdg/labyrinth/Land.jpg"); //image gebruik je om de afbeelding op te halen uit een bestand
        ImageView backgroundView = new ImageView(backgroundImage); //imageview wordt gebruikt om de afbeelding te laten tonen op de UI
        backgroundView.setFitWidth(1920); //de grootte instellen van de afbeelding
        backgroundView.setFitHeight(1080);

        Region overlay = new Region(); //dit is eigenlijk een lege container. Word gebruikt voor effects
        overlay.setPrefSize(800, 600);
        overlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);"); //het effect zal 50% zichtbaar zijn.

        HBox highscoresBox = new HBox(50);
        highscoresBox.setAlignment(Pos.CENTER);
        highscoresBox.getChildren().addAll(easyHighscoresLabel, mediumHighscoresLabel, hardHighscoresLabel);

        VBox vbox = new VBox(20);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll(titleLabel, highscoresBox, backButton);

        this.getChildren().addAll(backgroundView, overlay, vbox);
        this.setAlignment(Pos.CENTER);

        //als je die css file wilt gebruiken moet je die toevoegen aan een scene
        //Scene scene = new Scene(this, 1000, 800)
        // scene.getStyleSheets().add(getClass().getRecources(Pad van u bestand).toExternalForm());
    }

    public Button getBackButton() {
        return backButton;
    }

    //wij maken 3 getters voor onze labels zodat we die kunnen gebruiken in de presenter
    public Label getEasyHighscoresLabel() {
        return easyHighscoresLabel;
    }

    public Label getMediumHighscoresLabel() {
        return mediumHighscoresLabel;
    }

    public Label getHardHighscoresLabel() {
        return hardHighscoresLabel;
    }
}