package be.kdg.labyrinth.JavaFX.view;

import be.kdg.labyrinth.JavaFX.model.GameModel;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class StartPresenter {
    private final GameModel model;
    private final StartView view;
    private final Stage stage; //je maakt van tevoren al een stage aan zodat alles in hetzelfde scherm wordt getoond

    public StartPresenter(GameModel model, StartView view, Stage stage) {
        this.model = model;
        this.view = view;
        this.stage = stage;
        addEventHandlers();
    }

    private void addEventHandlers() { // allemaal events die worden uitgevoert als je op een knop drukt
        view.getPlayButton().setOnAction(e -> showDifficulty());
        view.getAboutButton().setOnAction(e -> showAbout());
        view.getTutorialButton().setOnAction(e -> showTutorial());
        view.getHighscoresButton().setOnAction(e -> showHighscores());
        view.getExitButton().setOnAction(e -> stage.close());
    }

    private void showDifficulty() { //dit zorgt ervoor dat de moeilijkheidsscherm wordt getoond
        DifficultyView difficultyView = new DifficultyView(); //je roept de difficultyview aan
        new DifficultyPresenter(difficultyView, stage, model); //je roept de presenter aan en die koppelen we aan de view omdat die alle logica bevat.
        Scene scene = new Scene(difficultyView, 1500, 800); //je maakt een scene aan voor alle UI elementen.
        stage.setScene(scene); //zorgt ervoor dat het scherm wordt getoond
        stage.setFullScreen(false); //het scherm is niet fullscreen
        stage.setResizable(true); //je kan hem wel grote of kleiner maken
    }

    private void showAbout() { //dit zorgt ervoor dat de about scherm wordt getoond
        AboutView aboutView = new AboutView(true);
        new AboutPresenter(aboutView, stage);
        Scene scene = new Scene(aboutView, 1500, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }

    private void showTutorial() { //dit zorgt ervoor dat de tutorial scherm wordt getoond
        TutorialView tutorialView = new TutorialView(true);
        new TutorialPresenter(tutorialView, stage);
        Scene scene = new Scene(tutorialView, 1500, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }

    private void showHighscores() { //dit zorgt ervoor dat de highscore scherm wordt getoond
        HighscoresView highscoresView = new HighscoresView();
        new HighscoresPresenter(highscoresView, stage);
        Scene scene = new Scene(highscoresView, 1500, 800);
        stage.setScene(scene);
        stage.setFullScreen(false);
        stage.setResizable(true);
    }
}